<?php

include ('includes/header.php');
$base_file = basename($_SERVER['PHP_SELF']);

$table_name = "extra_accounts";

$res = $db->select($table_name);

$update_id = isset($_GET['update']) ? sanitize($_GET['update']) : false;
if ($update_id) {
    $resU = $db->select($table_name, '*', "id='{$update_id}'");
    $rowU = $resU[0] ?? null; 
}

if (isset($_POST['submitU']) && $update_id) {
    $expiryDate = new DateTime($_POST['expiry']);
    $currentDate = new DateTime();
    $status = ($expiryDate >= $currentDate) ? 'Active' : 'Expired';

    $data = array(
        'username' => $_POST['username'],
        'password' => $_POST['password'],
        'status'   => $status,
        'expiry'   => $_POST['expiry']
    );
    $db->update($table_name, $data, "id='{$update_id}'");
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}


if (isset($_POST['submit'])) {
    $expiryDate = new DateTime($_POST['expiry']);
    $currentDate = new DateTime();
    $status = ($expiryDate >= $currentDate) ? 'Active' : 'Expired';

    $data = [
        'username' => $_POST['username'],
        'password' => $_POST['password'],
        'status' => $status,
        'expiry' => $_POST['expiry']
    ];

    $db->insert($table_name, $data);

    echo "<script>window.location.href='". htmlspecialchars(basename($_SERVER["SCRIPT_NAME"]))."?status=1'</script>";
}

if (isset($_GET['delete'])) {
    $deleteId = sanitize($_GET['delete']); 
    $db->delete($table_name, "id='{$deleteId}'");

    echo "<script>window.location.href='". htmlspecialchars(basename($_SERVER["SCRIPT_NAME"]))."?status=2'</script>";
}

$displayStatus = ($expiryDate >= $currentDate) ? '<span class="status-active">Active <i class="fa fa-check-circle"></i></span>' : '<span class="status-expired">Expired <i class="fa fa-times-circle"></i></span>';
//delete modal
?>
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Confirm</h2>
            </div>
            <div class="modal-body">
                Do you really want to delete?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>
<?php
if (isset($_GET['create'])){

//create form
?>
        <div class="col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-primary text-white">
                    <div class="card-header card-header-warning">
                        <center>
                            <h2><i class="fa fa-user-plus"></i> Extra Account's</h2>
                        </center>
                    </div>
                    
                    <div class="card-body">
                        <div class="col-12">
                            <h3> Extra Account's</h3>
                        </div>
                            <form method="post">
                                <div class="form-group">
                                    <label class="form-label " for="username">Username</label>
                                        <input class="form-control" id="description" name="username" placeholder="username" type="text"/>
                                </div>
                                <div class="form-group">
                                    <label class="form-label " for="password">Password</label>
                                        <input class="form-control" id="description" name="password" placeholder="password" type="text"/>
                                </div>
								
								<div class="form-group">
								<label for="expiry">Expiry</label>
								<input class="form-control" id="expiry" name="expiry" type="date" placeholder="Expiry"/>
								</div>

                                <div class="form-group">
                                    <center>
                                        <button class="btn btn-info " name="submit" type="submit">
                                            <i class="icon icon-check"></i> Submit
                                        </button>
                                    </center>
                                </div>
                            </form>
                    </div>
                </div>
            </div>
        </div>

<?php 
}else if (isset($_GET['update'])){ 

//update form
?>
        <div class="col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-primary text-white">
                    <div class="card-header card-header-warning">
                        <center>
                            <h2><i class="fa fa-user-plus"></i> Edit Account</h2>
                        </center>
                    </div>
                    
                    <div class="card-body">
                        <div class="col-12">
                            <h3>Edit Account</h3>
                        </div>
                            <form method="post">
                                <div class="form-group">
                                    <label class="form-label " for="username">Username</label>
                                        <input class="form-control" id="description" name="username" placeholder="username" value="<?=$rowU['username'] ?>" type="text"/>
                                </div>
                                <div class="form-group">
                                    <label class="form-label " for="password">Password</label>
                                        <input class="form-control" id="description" name="password" placeholder="password" value="<?=$rowU['password'] ?>" type="text"/>
                                </div>
								<div class="form-group">
								<label for="expiry">Expiry</label>
								<input class="form-control" id="expiry" name="expiry" type="date" placeholder="Expiry" value="<?=$rowU['expiry'] ?>"/>
								</div>
                                <div class="form-group">
                                    <center>
                                        <button class="btn btn-info " name="submitU" type="submit">
                                            <i class="icon icon-check"></i> Submit
                                        </button>
                                    </center>
                                </div>
                            </form>
                    </div>
                </div>
            </div>
        </div>
<?php 
} else {
    // Main table/form
?>
<style>
.status-active {
    background-color: green; /* This sets the background for active status */
    color: white; /* Keeps the text color white */
    padding: 2px 6px; /* Adjust padding to your liking */
    border-radius: 5px; /* Adds rounded corners */
    font-weight: bold;
}

.status-expired {
    background-color: red; /* And this one for expired status */
    color: white; /* Text color stays white here as well */
    padding: 2px 6px; /* Feel free to tweak the padding */
    border-radius: 5px; /* And the border-radius for consistency */
    font-weight: bold;
}
</style>
    <div class="col-md-12 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="fa fa-user-plus"></i> Extra Account's</h2>
                    </center>
                </div>
                <div class="card-body">
                    <div class="col-12">
                        <center>
                            <a id="button" href="./<?php echo htmlspecialchars($base_file) ?>?create" class="btn btn-info">New Account</a>
                        </center>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <input class="form-control" type="text" id="search" onkeyup="func2()" placeholder="Type to search">
							<table class="table table-striped table-sm">
							<thead style="color:white!important">
                                <tr>
                                    <th>Index</th>
                                    <th>Username</th>
                                    <th>Password</th>
                                    <th>Status</th>
                                    <th>Expiry</th>
                                    <th>Edit&nbsp;&nbsp;&nbsp;Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($res as $row) {
                                $expiryDate = new DateTime($row['expiry']);
                                $currentDate = new DateTime();
                                $displayStatus = ($expiryDate >= $currentDate) ? '<span class="status-active">Active <i class="fa fa-check-circle"></i></span>' : '<span class="status-expired">Expired <i class="fa fa-times-circle"></i></span>';
                            ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['id']) ?></td>
                                    <td><?= htmlspecialchars($row['username']) ?></td>
                                    <td><?= htmlspecialchars($row['password']) ?></td>
                                    <td><?= $displayStatus ?></td>
                                    <td><?= htmlspecialchars($row['expiry']) ?></td>
                                    <td>
                                        <a class="btn btn-info btn-ok" href="./<?php echo htmlspecialchars($base_file) ?>?update=<?= htmlspecialchars($row['id']) ?>"><i class="fa fa-pencil-square-o"></i></a>
                                        &nbsp;&nbsp;&nbsp;
                                        <a class="btn btn-danger btn-ok" href="#" data-href="./<?php echo htmlspecialchars($base_file) ?>?delete=<?= htmlspecialchars($row['id']) ?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php 
}
?>

<?php include ('includes/footer.php');?>

</body>
</html>